<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleReportsCreateTokenStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'token',
        'title_column' => 'token',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'token' => "anomaly.field_type.text",
        'expire_date' => "anomaly.field_type.datetime",
        'status' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true
            ]
        ]
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'token',
        'expire_date',
        'status'
    ];

}
