<?php namespace Visiosoft\ReportsModule\Report\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ReportTableColumns
{
    public function handle(TableBuilder $builder)
    {
        $builder->setColumns([
            'name' => [
                'value' => function (EntryInterface $entry) {
                    $value = $entry->getName();
                    $suffix = $entry->isParent() ? ' <small class="text-info"><i class="fa fa-chevron-right text-danger"></i> ' . $entry->parent->getName() . '</small>' : '';

                    return $value . $suffix;
                }]]);
    }
}