<?php namespace Visiosoft\ReferencesModule\Reference\Listener;

use Illuminate\Support\Facades\Cookie;
use Visiosoft\ReferencesModule\Events\ReferenceWasCreated;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;

class AddReferenceUser
{
    protected $referenceRepository;

    public function __construct(ReferenceRepositoryInterface $referenceRepository)
    {
        $this->referenceRepository = $referenceRepository;
    }
    public function handle(UserHasRegistered $event)
    {
        if ($referenceId = Cookie::get('reference_id')) {
            $user = $event->getUser();
            $reference = $this->referenceRepository->create([
                'user' => $user,
                'referenced_user_id' => $referenceId,
            ]);

            event(new ReferenceWasCreated($reference));
        }
    }
}
