<?php namespace Visiosoft\ReferencesModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class ReferencesModuleSeeder extends Seeder
{
    private $templateRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        parent::__construct();
        $this->templateRepository = $templateRepository;
    }

    public function run()
    {
        $template = $this->templateRepository->findBySlug('reference_notification');
        if (!$template) {
            $this->templateRepository->create([
                'en' => [
                    'message' => '<p>{referenced_name} You have been invited by {reference_name} to register on {site}. Click on <a href="{activation_link}" target="_blank">this link</a> to complete your registration. You can use this password to login to your account: {password}</p>',
                    'name' => 'Reference Notification',
                    'greeting' => 'Hello',
                    'subject' => 'You have been referenced'
                ],
                'slug' => 'reference_notification'
            ]);
        }
    }
}
