<?php namespace Visiosoft\ReferencesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\ReferenceRepository;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;
use Visiosoft\ReferencesModule\Reference\ReferenceModel;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\ReferencesModule\Reference\Listener\AddReferenceUser;

class ReferencesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        // Admin ReferencesController
        'admin/references'           => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@index',
        'admin/references/create'    => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@create',
        'admin/references/edit/{id}' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@edit',
        'admin/references/list-references' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@listReferences',

        // referencesController
        'references' => [
            'middleware'   => 'auth',
            'as'   => 'visiosoft.module.favs::references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@index'
        ],
        'reference/{userId}' => [
            'as' => 'references::referenceUser',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@referenceUser'
        ],
        'references/api/send-invites' => 'Visiosoft\ReferencesModule\Http\Controller\ReferencesController@sendInvites',

        // ApiController
        'api/get-references' => [
            'as' => 'visiosoft.module.references::api_get_references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\ApiController@getReferences',
        ],
        'api/register-reference' => [
            'as' => 'visiosoft.module.references::api_register_reference',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\ApiController@register'
        ]
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\ReferencesModule\Event\ExampleEvent::class => [
        //    Visiosoft\ReferencesModule\Listener\ExampleListener::class,
        //],
        UserHasRegistered::class => [
           AddReferenceUser::class
        ],
        'Visiosoft\OffersModule\Events\CreatedOffer' => [
            'Visiosoft\ReferencesModule\Listeners\MessageReferenceOfOffer'
        ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        ReferencesReferencesEntryModel::class => ReferenceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ReferenceRepositoryInterface::class => ReferenceRepository::class,
    ];

}
