<?php

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;

return [
    'referable_roles' => [
        "type"   => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "default_value" => ["user"],
            "handler" => function (
                CheckboxesFieldType $fieldType,
                RoleRepositoryInterface $roleRepository
            ) {
                $roles = $roleRepository->newQuery()->get()->pluck('name', 'slug')->all();
                $fieldType->setOptions($roles);
            }
        ]
    ],
];
