<?php namespace Visiosoft\ReferencesModule\Reference\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ReferenceTableBuilder extends TableBuilder
{
    protected $filters = [
        'referenced_user',
        'created_at',
        'user',
    ];

    protected $columns = [
        'referenced_user' => [
            'value' => 'entry.referenced_user.name'
        ],
        'user' => [
            'value' => 'entry.user.name'
        ],
        'referenced_at' => [
            'heading' => 'visiosoft.module.references::field.referenced_at',
            'value' => 'entry.created_at'
        ],
    ];

    protected $buttons = [
        'view_orders' => [
            'href' => '/purchase?user={entry.user_id}',
        ],
        'edit'
    ];

    protected $actions = [
        'delete'
    ];

    protected $assets = [
        //TODO::add-filter-user-reference-js
        'scripts.js' => [
            'visiosoft.module.references::js/admin/filter-reference-user.js',
        ],
    ];
}
