<?php namespace Visiosoft\ReferencesModule\Reference;

use Illuminate\Support\Facades\DB;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;

class ReferenceRepository extends EntryRepository implements ReferenceRepositoryInterface
{
    protected $model;

    public function __construct(ReferenceModel $model)
    {
        $this->model = $model;
    }

    public function getUserReferences($userID = null)
    {
        $userID = auth_id_if_null($userID);
        return $this->findAllBy('referenced_user_id', $userID);
    }

    public function getReferenceToMe($userID = null)
    {
        $userID = auth_id_if_null($userID);
        return $this->findBy('user_id', $userID);
    }

    public function createReference($data)
    {
        return $this->create($data);
    }

    public function countReferences()
    {
        return DB::table('references_references')->count();
    }

    public function queryDefault()
    {
        return $this->model->selectBasic()->filterByActivated()->withCode()->withUser();
    }

    public function getReferencesByUser($userId)
    {
        return $this->queryDefault()->filterByReferencedUser($userId)->get();
    }

    public function getReference(int $referenceId)
    {
        return $this->queryDefault()->filterById($referenceId)->withReferencedUser()->first();
    }

    public function getReferences()
    {
        return $this->queryDefault()->withReferencedUser()->get();

    }

    /**
     * @throws \Exception
     */
    public function createReferenceByCode(int $userId, string $code)
    {
        $codeRepository = app(ReferenceCodeRepositoryInterface::class);
        $code = $codeRepository->getCodeByCodeString($code);

        if ($code) {
            return $this->model->create([
                'user_id' => $userId,
                'referenced_user_id' => $code->getUserId(),
                'code_id' => $code->getId()
            ]);
        }

        return null;

    }
}
