<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleReferencesCreateReferenceCodesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'reference_codes',
        'title_column' => 'code_string',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'code_string' => 'anomaly.field_type.text'
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'user' => [
            'required' => true,
        ],
        'code_string' => [
            'unique' => true,
            'required' => true,
        ]
    ];

}
