<?php namespace Visiosoft\ReferencesModule\Payment\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class PaymentTableButtons
{
    public function handle(PaymentTableBuilder $builder)
    {
        $builder->setButtons([
            'status' => [
                'text' => function (EntryInterface $entry) {
                    return trans('visiosoft.module.references::button.' . ($entry->status == 'approved' ? 'refuse' : 'approve'));
                },
                'href' => function (EntryInterface $entry) {
                    return "/admin/references/payments/status/{entry.id}/" . ($entry->status == 'approved' ? 'refused' : 'approved');
                },
                'type' => function (EntryInterface $entry) {
                    return $entry->status == 'approved' ? "danger" : "success";
                },
            ],
            'view',
            'edit',
        ]);
    }
}
