<?php namespace Visiosoft\ReferencesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\ReferenceRepository;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;
use Visiosoft\ReferencesModule\Reference\ReferenceModel;
use Illuminate\Routing\Router;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\ReferencesModule\Reference\Listener\AddReferenceUser;

class ReferencesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/references'           => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@index',
        'admin/references/create'    => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@create',
        'admin/references/edit/{id}' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@edit',
        'references' => [
            'middleware'   => 'auth',
            'as'   => 'visiosoft.module.favs::references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@index'
        ],
        'reference/{userId}' => [
            'as' => 'references::referenceUser',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@referenceUser'
        ],
        'references/api/send-invites' => 'Visiosoft\ReferencesModule\Http\Controller\ReferencesController@sendInvites',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\ReferencesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\ReferencesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\ReferencesModule\Event\ExampleEvent::class => [
        //    Visiosoft\ReferencesModule\Listener\ExampleListener::class,
        //],
        UserHasRegistered::class => [
           AddReferenceUser::class
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\ReferencesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        ReferencesReferencesEntryModel::class => ReferenceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ReferenceRepositoryInterface::class => ReferenceRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
