<?php namespace Visiosoft\ReferencesModule\ReferenceCode;

use Anomaly\Streams\Platform\Entry\EntryQueryBuilder;

class ReferenceCodeQueryBuilder extends EntryQueryBuilder
{
    public function selectBasic(): ReferenceCodeQueryBuilder
    {
        return $this->select(['id', 'created_at', 'user_id', 'code_string']);
    }

    public function withUser(): ReferenceCodeQueryBuilder
    {
        return $this->with(['user' => function ($q) {
            $q->select(['id', 'username']);
        }]);
    }

    public function filterByCodeString(string $codeString): ReferenceCodeQueryBuilder
    {
        return $this->where('code_string', $codeString);
    }

    public function filterById(int $id): ReferenceCodeQueryBuilder
    {
        return $this->where('id', $id);
    }

    public function filterByUserId(int $userId): ReferenceCodeQueryBuilder
    {
        return $this->where('user_id', $userId);
    }

    public function orderByLatest(string $dateColumn = "created_at"): ReferenceCodeQueryBuilder
    {
        return $this->orderBy($dateColumn, 'DESC');
    }
}
