<?php namespace Visiosoft\ReferencesModule\Reference;

use Anomaly\Streams\Platform\Entry\EntryQueryBuilder;

class ReferenceQueryBuilder extends EntryQueryBuilder
{
    public function selectBasic(): ReferenceQueryBuilder
    {
        return $this->select(['id', 'created_at', 'referenced_user_id', 'user_id', 'code_id']);
    }

    public function filterById(int $referenceId): ReferenceQueryBuilder
    {
        return $this->where('id', $referenceId);
    }

    public function filterByActivated(): \Illuminate\Database\Eloquent\Builder|ReferenceQueryBuilder
    {
        return $this->whereHas('user', function ($q) {
            $q->where('activated', true);
        });
    }

    public function filterByReferencedUser(int $userId): ReferenceQueryBuilder
    {
        return $this->where('referenced_user_id', $userId);
    }


    public function withUser(): ReferenceQueryBuilder
    {
        return $this->with(['user' => function ($q) {
            $q->select(['id', 'username']);
        }]);
    }

    public function withReferencedUser(): ReferenceQueryBuilder
    {
        return $this->with(['referencedUser' => function ($q) {
            $q->select(['id', 'username']);
        }]);
    }

    public function withCode(): ReferenceQueryBuilder
    {
        return $this->with(['code' => function ($q) {
            $q->select(['id', 'code_string']);
        }]);
    }
}
