<?php namespace Visiosoft\ReferencesModule\Reference;

use Anomaly\UsersModule\User\Contract\UserInterface;
use Visiosoft\MapilioModule\UserModel;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceInterface;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;

class ReferenceModel extends ReferencesReferencesEntryModel implements ReferenceInterface
{
    public function reference($user, $reference_id)
    {
        $param = [];
        $param['user_id'] = $user;
        $param['related_user_id'] = $reference_id;
        ReferencesReferencesEntryModel::create($param);
        return response()->json([
            'success' => true
        ]);
    }

    public function referencedUser()
    {
        return $this->belongsTo(UserModel::class);
    }

    public function getReferencedUser(): UserInterface
    {
        return $this->referenced_user;
    }

    public function getReferencedUserId(): int
    {
        return $this->referenced_user_id;
    }

    public function getUser(): UserInterface
    {
        return $this->user;
    }

    public function getUserId(): int
    {
        return $this->user_id;
    }
}
