<?php namespace Visiosoft\ReferencesModule\Payment\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class PaymentTableBuilder extends TableBuilder
{
    protected $filters = [
        'payment_type',
        'created_at',
        'status',
    ];

    protected $columns = [
        'entry.id',
        'entry.payment_type.value',
        'name',
        'entry.created_at',
        'entry.status.value',
        'amount',
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
        'order_by' => [
            'created_at' => 'DESC',
        ],
    ];
}
