<?php

namespace Visiosoft\ReferencesModule\Http\Controller\Api\V2;


use Illuminate\Http\JsonResponse;
use Visiosoft\ConnectModule\Traits\ReturnResponseTrait;
use Visiosoft\ReferencesModule\Reference\ReferenceRepository;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;
use Visiosoft\ReferencesModule\ReferenceCode\ReferenceCodeRepository;

class ReferenceController
{
    use ReturnResponseTrait;

    private ReferenceRepository $referenceRepository;
    private ReferenceCodeRepositoryInterface $referenceCodeRepository;

    public function __construct(ReferenceRepository $referenceRepository, ReferenceCodeRepository $referenceCodeRepository)
    {
        $this->referenceRepository = $referenceRepository;
        $this->referenceCodeRepository = $referenceCodeRepository;
    }

    public function index(int $referenceId = null): JsonResponse
    {
        if ($referenceId) {
            return $this->sendResponse($this->referenceRepository->getReference($referenceId));
        }

        return $this->sendResponse($this->referenceRepository->getReferences());

    }

    public function getReferencesByUser(int $userId): JsonResponse
    {
        return $this->sendResponse($this->referenceRepository->getReferencesByUser($userId));
    }

}
