<?php

namespace Visiosoft\ReferencesModule\Http\Controller\Api\V2;


use Illuminate\Http\JsonResponse;
use Visiosoft\ConnectModule\Traits\ReturnResponseTrait;
use Visiosoft\ReferencesModule\Reference\ReferenceRepository;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;
use Visiosoft\ReferencesModule\ReferenceCode\ReferenceCodeRepository;

class ReferenceCodeController
{
    use ReturnResponseTrait;

    private ReferenceRepository $referenceRepository;
    private ReferenceCodeRepositoryInterface $referenceCodeRepository;

    public function __construct(ReferenceRepository $referenceRepository, ReferenceCodeRepository $referenceCodeRepository)
    {
        $this->referenceRepository = $referenceRepository;
        $this->referenceCodeRepository = $referenceCodeRepository;
    }

    public function index(int $codeId = null): JsonResponse
    {
        if ($codeId) {
            return $this->sendResponse($this->referenceCodeRepository->getCode($codeId));
        }

        return $this->sendResponse($this->referenceCodeRepository->getCodes());

    }

    public function getReferenceCodeByUser(int $userId): JsonResponse
    {
        return $this->sendResponse($this->referenceCodeRepository->getCodeByUserId($userId));
    }
}
