const tagContainer = document.querySelector('.tag-container');
const input = document.querySelector('.tag-container input');

let tags = [];

function createTag(label) {
    const div = document.createElement('div');
    div.setAttribute('class', 'tag');
    const span = document.createElement('span');
    span.innerHTML = label;
    const closeIcon = document.createElement('i');
    closeIcon.setAttribute('class', 'fa fa-times');
    closeIcon.setAttribute('data-item', label);
    div.appendChild(span);
    div.appendChild(closeIcon);
    return div;
}

function clearTags() {
    document.querySelectorAll('.tag').forEach(tag => {
        tag.parentElement.removeChild(tag);
    });
}

function addTags() {
    clearTags();
    tags.slice().reverse().forEach(tag => {
        tagContainer.prepend(createTag(tag));
    });

    if (tags.length > 0) {
        $('#sendInvites').prop('disabled', false)
    } else  {
        $('#sendInvites').prop('disabled', true)
    }

    $('.invites-num').html(tags.length)
}

function validateEmail(email) {
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

input.addEventListener('keyup', (e) => {
    if (e.key === 'Enter' && e.target.value !== '') {
        const newTags = e.target.value.split(' ').filter((tag) => !!validateEmail(tag))
        tags = new Set(newTags);
        tags = [...tags]
        $('.tag-input .error-text').addClass('d-none');
        addTags();
        input.value = '';

        if (!validateEmail(tags[0])) {
            $('.tag-input .error-text').html(emailInvalid).removeClass('d-none')
        }
    }
});

document.addEventListener('click', (e) => {
    if (e.target.tagName === 'I') {
        const tagLabel = e.target.getAttribute('data-item');
        const index = tags.indexOf(tagLabel);
        tags = [...tags.slice(0, index), ...tags.slice(index + 1)];
        addTags();
    }
});

$('#sendInvites').click(() => {
    if (tags.length > 0) {
        $('.modal-body').hide();
        $('.modal-footer').hide();
        $('.invite-loader').addClass('d-flex');
        $.ajax({
            type: 'POST',
            url: 'references/api/send-invites',
            data: {
                emails: tags
            },
            error: function (xhr) {
                $('.tag-input .error-text').html('Error: ' + xhr.status + " " + xhr.statusText)
                    .removeClass('d-none');
                $('.modal-body:not(".invite-sent")').show();
                $('.modal-footer').show();
                $('.invite-loader').removeClass('d-flex');
            },
            success: function (data) {
                if (data.error) {
                    $('.tag-input .error-text').html(data.error.message).removeClass('d-none');
                    $('.modal-body:not(".invite-sent")').show();
                    $('.modal-footer').show();
                    $('.invite-loader').removeClass('d-flex');
                } else {
                    $('.invite-sent').show();
                    $('.invite-loader').removeClass('d-flex');
                }
            }
        });
    }
});

$(tagContainer).click(function (){
    $(input).focus();
})