<?php namespace Visiosoft\ReferencesModule\Http\Controller\Admin;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\Form\ReferenceFormBuilder;
use Visiosoft\ReferencesModule\Reference\ListTable\ListReferenceTableBuilder;
use Visiosoft\ReferencesModule\Reference\Table\ReferenceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ReferencesController extends AdminController
{
    public function index(ReferenceTableBuilder $table)
    {
        return $table->render();
    }

    public function create(ReferenceFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(ReferenceFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function listReferences(
        ListReferenceTableBuilder $table,
        ReferenceRepositoryInterface $referenceRepository
    ) {
        $users = $referenceRepository->newQuery();

        if ($dateFilter = request()->filter_created_at) {
            $dates = explode('to', $dateFilter);
            if (isset($dates[0]) && $dates[0]) {
                if (!isset($dates[1]) || !$dates[1]) {
                    $users = $users->whereDate('created_at', '=', Carbon::parse($dates[0]));
                } else {
                    $users = $users->whereDate('created_at', '>=', Carbon::parse($dates[0]));
                }
            }

            if (isset($dates[1]) && $dates[1]) {
                $users = $users->whereDate('created_at', '<=', Carbon::parse($dates[1]));
            }
        }

        $users = $users->select('referenced_user_id', DB::raw('count(*) as total'))
            ->groupBy('referenced_user_id')
            ->get();

        $table->setTableEntries($users);

        return $table->render();
    }
}
