<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\Http\Controller\RegisterController;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Notify\Notification\SendInvitesMail;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;

class ReferencesController extends PublicController
{
    private $registerController;
    private $referenceRepository;
    private $roleRepository;

    public function __construct(
        RegisterController $registerController,
        ReferenceRepositoryInterface $referenceRepository,
        RoleRepositoryInterface $roleRepository
    )
    {
        parent::__construct();

        $this->registerController = $registerController;
        $this->referenceRepository = $referenceRepository;
        $this->roleRepository = $roleRepository;
    }

    public function index() {
        $referenceToMe = $this->referenceRepository->getReferenceToMe();

        $referencedToUsers = $this->referenceRepository->getUserReferences();
        foreach ($referencedToUsers as $user) {
            $user->refered = $this->referenceRepository->getUserReferences($user->user_id);
        }

        $referableRoles = setting_value('visiosoft.module.references::referable_roles');
        $referableRoles = $referableRoles ?
            $this->roleRepository->newQuery()->whereIn('slug', $referableRoles)->get() : [];

        return $this->view->make('visiosoft.module.references::references', [
            'referencedToUsers' => $referencedToUsers,
            'referenceToMe' => $referenceToMe,
            'referableRoles' => $referableRoles
        ]);
    }

    public function referenceUser($userId) {
        if (!request()->hasCookie('reference_id')) {
            Cookie::queue(Cookie::make('reference_id', $userId, 84000));
        } else {
            if (Cookie::get('reference_id') !== $userId) {
                Cookie::queue(Cookie::make('reference_id', $userId, 84000));
            }
        }

        return redirect(route('anomaly.module.users::register'));
    }

    public function sendInvites() {
        try {
            foreach (request()->emails as $recipient) {
                Notification::route('mail', $recipient)->notify(new SendInvitesMail());
            }
        } catch (\Exception $error) {
            return ['error' => [
                'message' => 'Error: ' . $error->getMessage()
            ]];
        }

        return ['success' => true];
    }
}
