<?php namespace Visiosoft\ReferencesModule\Reference\Listener;

use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Illuminate\Http\Request;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;

class AddReferenceUser
{
    protected $user;
    protected $references;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }
    public function handle(UserHasRegistered $event)
    {
        $this->user = $event->getUser();
        $all = [
            'user_id' => $this->user->id,
            'related_user_id' => $this->request->ref_no
        ];
        ReferencesReferencesEntryModel::create($all);
    }
}
