<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\Http\Controller\RegisterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;

class ReferencesController extends PublicController
{
    private $registerController;

    public function __construct(RegisterController $registerController)
    {
        parent::__construct();

        $this->registerController = $registerController;
    }

    public function referenceUser($userId, Request $request) {
        if (!$request->hasCookie('reference_id')) {
            Cookie::queue(Cookie::make('reference_id', $userId, 84000));
        } else {
            if (Cookie::get('reference_id') !== $userId) {
                Cookie::queue(Cookie::make('reference_id', $userId, 84000));
            }
        }

        return redirect(route('anomaly.module.users::register'));
    }
}
