<?php namespace Visiosoft\ReferencesModule\Http\Controller\Admin;

use Visiosoft\ReferencesModule\Reference\Form\ReferenceFormBuilder;
use Visiosoft\ReferencesModule\Reference\Table\ReferenceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ReferencesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ReferenceTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ReferenceTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ReferenceFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ReferenceFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ReferenceFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ReferenceFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
