<?php namespace Visiosoft\ReferencesModule\Traits;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\ReferencesModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;

trait PaymentTrait
{
    private $referenceRepository;
    private $orderRepository;

    public function getTotalPayments()
    {
        if (is_module_installed('visiosoft.module.orders')) {
            $referenceRepository = app(ReferenceRepositoryInterface::class);
            $paymentRepository = app(PaymentRepositoryInterface::class);
            $orderRepository = app(OrderRepositoryInterface::class);

            $userIDs = $referenceRepository->getUserReferences()->pluck('user_id')->all();
            foreach ($userIDs as $userID) {
                $userIDs = array_merge(
                    $userIDs,
                    $referenceRepository->getUserReferences($userID)->pluck('user_id')->all()
                );
            }

            $commission = auth()->user()->commission ?: setting_value('visiosoft.module.references::default_commission');
            $totalPayment = $paymentRepository->approvedUserPayments()->sum('amount');
            $totalReceivable = $orderRepository->getUsersOrdersTotal($userIDs) - $totalPayment;
            $totalReceivable = ($commission / 100) * $totalReceivable;

            return $totalReceivable < 0 ? 0 : $totalReceivable;
        }

        return null;
    }
}