<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Validator;
use Visiosoft\ReferencesModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\ReferencesModule\Traits\PaymentTrait;

class PaymentsController extends PublicController
{
    use PaymentTrait;

    public function index(PaymentRepositoryInterface $paymentRepository)
    {
        $payments = $paymentRepository
            ->userPayments()
            ->orderByDesc('created_at')
            ->paginate(setting_value('streams::per_page'));

        return view('visiosoft.module.references::payments.index')->with('payments', $payments);
    }

    public function create(PaymentRepositoryInterface $paymentRepository)
    {
        if (request()->method() === 'GET') {
            return view('visiosoft.module.references::payments.create');
        } elseif (request()->method() === 'POST' && request()->payment_type) {
            $sharedFieldsValidation = [
                'address' => 'required',
                'contact' => 'required',
                'iban_no' => 'required',
                'bank_name' => 'required',
                'name' => 'required',
            ];

            if (request()->payment_type === 'individual') {
                $validator = Validator::make(request()->all(), array_merge([
                    'id_number' => 'required',
                ], $sharedFieldsValidation));
            } elseif (request()->payment_type === 'commercial') {
                $validator = Validator::make(request()->all(), array_merge([
                    'tax_administration' => 'required',
                    'tax_no' => 'required',
                ], $sharedFieldsValidation));
            } else {
                abort(404);
            }

            if ($validator->fails()) {
                $this->messages->error($validator->messages()->first());
                return redirect()->back()->withInput();
            }

            $data = array_filter(request()->only([
                'payment_type', 'address', 'contact', 'iban_no',
                'bank_name', 'name', 'id_number',
                'tax_administration', 'tax_no'
            ]), function ($value) {
                return !empty($value);
            });

            $paymentRepository->create(array_merge($data, [
                'amount' => $this->getTotalPayments()
            ]));

            $this->messages->success(trans('visiosoft.module.references::message.payment_request_created'));

            return redirect()->route('visiosoft.module.favs::references');
        }
    }
}
