<?php namespace Visiosoft\ReferencesModule\Reference\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ReferenceTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'referenced_user',
        'user',
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'referenced_user' => [
            'value' => 'entry.referenced_user.name'
        ],
        'user' => [
            'value' => 'entry.user.name'
        ],
        'referenced_at' => [
            'heading' => 'visiosoft.module.references::field.referenced_at',
            'value' => 'entry.created_at'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'view_orders' => [
            'href' => '/purchase?user={entry.user_id}',
        ],
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
