<?php namespace Visiosoft\ReferencesModule\Reference;

use Illuminate\Support\Facades\DB;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ReferenceRepository extends EntryRepository implements ReferenceRepositoryInterface
{
    protected $model;

    public function __construct(ReferenceModel $model)
    {
        $this->model = $model;
    }

    public function getUserReferences($userID = null)
    {
        $userID = auth_id_if_null($userID);
        return $this->findAllBy('referenced_user_id', $userID);
    }

    public function createReference($data)
    {
        return $this->create($data);
    }

    public function countReferences()
    {
        return DB::table('references_references')->count();
    }
}
