<?php namespace Visiosoft\ReferencesModule\ReferenceCode;

use Illuminate\Support\Str;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ReferenceCodeRepository extends EntryRepository implements ReferenceCodeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ReferenceCodeModel
     */
    protected $model;

    /**
     * Create a new ReferenceCodeRepository instance.
     *
     * @param ReferenceCodeModel $model
     */
    public function __construct(ReferenceCodeModel $model)
    {
        $this->model = $model;
    }

    protected function queryDefault()
    {
        return $this->model->selectBasic();
    }

    public function getCode(int $id)
    {
        return $this->queryDefault()->filterById($id)->first();
    }

    public function getCodes()
    {
        return $this->queryDefault()->withUser()->get();
    }

    public function getCodeByUserId(int $userId)
    {
        return $this->queryDefault()->filterByUserId($userId)->orderByLatest()->first();
    }

    public function getCodeByCodeString(string $code)
    {
        return $this->queryDefault()->filterByCodeString($code)->first();
    }

    public function createCode(int $userId): void
    {
        $this->model->create([
            'user_id' => $userId,
            'code_string' => Str::random(8)
        ]);
    }
}
