<?php namespace Visiosoft\ReferencesModule\Reference\Listener;

use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Support\Facades\Log;
use Visiosoft\ConnectModule\Events\UserRegistered;
use Visiosoft\ReferencesModule\Helpers\ReferenceCodeHelper;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;

class AddReferenceListener
{
    private ReferenceRepositoryInterface $referenceRepository;
    private ReferenceCodeRepositoryInterface $referenceCodeRepository;

    public function __construct(ReferenceRepositoryInterface $referenceRepository, ReferenceCodeRepositoryInterface $referenceCodeRepository)
    {
        $this->referenceRepository = $referenceRepository;
        $this->referenceCodeRepository = $referenceCodeRepository;
    }

    public function handle(UserRegistered $event)
    {
        try {
            $user = $event->getUser();
            $this->createReferenceCode($user);
            $this->assignReferenceCode($user);
        } catch (\Exception $e) {
            Log::error($e);
        }

    }

    private function createReferenceCode(UserInterface $user): void
    {
        $this->referenceCodeRepository->createCode($user->getId());
    }

    private function assignReferenceCode(UserInterface $user): void
    {
        if ($user->referrer)
        {
            $this->referenceRepository->createReferenceByCode($user->getId(), $user->referrer);
        }
    }


}
