<?php namespace Visiosoft\ReferencesModule\Payment;

use Visiosoft\ReferencesModule\Payment\Contract\PaymentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PaymentRepository extends EntryRepository implements PaymentRepositoryInterface
{
    protected $model;

    public function __construct(PaymentModel $model)
    {
        $this->model = $model;
    }

    public function userPayments($userID = null)
    {
        $userID = auth_id_if_null($userID);

        return $this->newQuery()->where('created_by_id', $userID);
    }

    public function approvedUserPayments($userID = null)
    {
        $userID = auth_id_if_null($userID);

        return $this->userPayments($userID)->where('status', 'approved');
    }

    public function pendingUserPayments($userID = null)
    {
        $userID = auth_id_if_null($userID);

        return $this->userPayments($userID)->where('status', 'pending');
    }
}
