<?php namespace Visiosoft\ReferencesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\References\ReferencesPaymentsEntryModel;
use Visiosoft\ReferencesModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\ReferencesModule\Payment\PaymentModel;
use Visiosoft\ReferencesModule\Payment\PaymentRepository;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\ReferenceRepository;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;
use Visiosoft\ReferencesModule\Reference\ReferenceModel;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\ReferencesModule\Reference\Listener\AddReferenceUser;

class ReferencesModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        // Admin ReferencesController
        'admin/references'           => [
            'as' => 'visiosoft.module.references::admin_references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@index',
        ],
        'admin/references/create'    => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@create',
        'admin/references/edit/{id}' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@edit',
        'admin/references/list-references' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\ReferencesController@listReferences',

        // referencesController
        'references' => [
            'middleware'   => 'auth',
            'as'   => 'visiosoft.module.favs::references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@index'
        ],
        'reference/{userId}' => [
            'as' => 'references::referenceUser',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\referencesController@referenceUser'
        ],
        'references/api/send-invites' => 'Visiosoft\ReferencesModule\Http\Controller\ReferencesController@sendInvites',

        // ApiController
        'api/get-references' => [
            'as' => 'visiosoft.module.references::api_get_references',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\ApiController@getReferences',
        ],
        'api/register-reference' => [
            'as' => 'visiosoft.module.references::api_register_reference',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\ApiController@register'
        ],

        // PaymentsController
        'references/payments' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.references::references.payments.index',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\PaymentsController@index'
        ],
        'references/payments/create' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.references::references.payments.create',
            'uses' => 'Visiosoft\ReferencesModule\Http\Controller\PaymentsController@create'
        ],

        // Admin PaymentsController
        'admin/references/payments/status/{payment_id}/{status}' => 'Visiosoft\ReferencesModule\Http\Controller\Admin\PaymentsController@status',
    ];

    protected $listeners = [
        UserHasRegistered::class => [
           AddReferenceUser::class
        ],
        'Visiosoft\OffersModule\Events\CreatedOffer' => [
            'Visiosoft\ReferencesModule\Listeners\MessageReferenceOfOffer'
        ]
    ];

    protected $bindings = [
        ReferencesReferencesEntryModel::class => ReferenceModel::class,
        ReferencesPaymentsEntryModel::class => PaymentModel::class,
    ];

    protected $singletons = [
        ReferenceRepositoryInterface::class => ReferenceRepository::class,
        PaymentRepositoryInterface::class => PaymentRepository::class,
    ];
}
