<?php namespace Visiosoft\ReferencesModule\Http\Controller\Admin;

use Visiosoft\ReferencesModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\ReferencesModule\Payment\Form\PaymentFormBuilder;
use Visiosoft\ReferencesModule\Payment\Table\PaymentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PaymentsController extends AdminController
{
    public function index(PaymentTableBuilder $table)
    {
        return $table->render();
    }

    public function create(PaymentFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(PaymentFormBuilder $form, PaymentRepositoryInterface $paymentRepository, $id)
    {
        if (!$payment = $paymentRepository->find($id)) {
            abort(404);
        }

        if ($payment->payment_type === 'individual') {
            $form->setSkips(['tax_administration', 'tax_no']);
        } elseif ($payment->payment_type === 'commercial') {
            $form->skipField('id_number');
        }

        return $form->render($id);
    }

    public function status(PaymentRepositoryInterface $paymentRepository, $id, $status)
    {
        if (!($payment = $paymentRepository->find($id)) || !in_array($status, ['approved', 'refused'])) {
            abort(404);
        }

        $payment->update([
            'status' => $status
        ]);

        return redirect()->back();
    }
}
