<?php namespace Visiosoft\ReferencesModule\Listeners;

use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\OffersModule\Events\CreatedOffer;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;

class MessageReferenceOfOffer
{

    private $chatRepository;
    private $referenceRepository;
    private $messageRepository;

    public function __construct(
        ChatRepositoryInterface $chatRepository,
        ReferenceRepositoryInterface $referenceRepository,
        MessageRepositoryInterface $messageRepository
    )
    {
        $this->chatRepository = $chatRepository;
        $this->referenceRepository = $referenceRepository;
        $this->messageRepository = $messageRepository;
    }

    public function handle(CreatedOffer $event)
    {
        $offeredTo = $event->getOfferedTo();
        $offerId = $event->getOfferId();

        // Check if got referenced
        $reference = $this->referenceRepository->findBy('user_id', $offeredTo->id);

        if ($reference) {
            // Check if chat exists
            $chat = $this->chatRepository->findChatByUsers($reference->referenced_user_id);
            if (!$chat) {
                $chat = $this->chatRepository->create([
                    'user_1_id' => auth()->id(),
                    'user_2_id' => $reference->referenced_user_id,
                ]);
            }

            $this->messageRepository->create([
                'title' => trans('visiosoft.module.references::message.your_referenced_user_got_offered_title'),
                'detail' => trans('visiosoft.module.references::message.your_referenced_user_got_offered_title_content', [
                        'name' => $offeredTo->name()
                    ]) . $offerId,
                'chat_id' => $chat->id,
            ]);
        }
    }
}