<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\Http\Controller\RegisterController;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Notify\Notification\SendInvitesMail;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;
use Visiosoft\ReferencesModule\Reference\Event\SendInvites;

class ReferencesController extends PublicController
{
    private $registerController;
    private $referenceRepository;

    public function __construct(
        RegisterController $registerController,
        ReferenceRepositoryInterface $referenceRepository
    )
    {
        parent::__construct();

        $this->registerController = $registerController;
        $this->referenceRepository = $referenceRepository;
    }

    public function index() {
        $referencedToUsers = $this->referenceRepository->findAllBy('referenced_user_id', auth()->id());
        return $this->view->make('visiosoft.module.references::references', ['referencedToUsers' => $referencedToUsers]);
    }

    public function referenceUser($userId) {
        if (!request()->hasCookie('reference_id')) {
            Cookie::queue(Cookie::make('reference_id', $userId, 84000));
        } else {
            if (Cookie::get('reference_id') !== $userId) {
                Cookie::queue(Cookie::make('reference_id', $userId, 84000));
            }
        }

        return redirect(route('anomaly.module.users::register'));
    }

    public function sendInvites() {
        try {
            foreach (request()->emails as $recipient) {
                Notification::route('mail', $recipient)->notify(new SendInvitesMail());
            }
        } catch (\Exception $error) {
            return ['error' => [
                'message' => 'Error: ' . $error->getMessage()
            ]];
        }

        return ['success' => true];
    }
}
