<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;

class ApiController extends PublicController
{
    private $referenceRepository;

    public function __construct(ReferenceRepositoryInterface $referenceRepository)
    {
        parent::__construct();
        $this->referenceRepository = $referenceRepository;
    }

    public function getReferences()
    {
        $references = $this->referenceRepository->getUserReferences(request()->user_id);
        $pluckedReferences = array();
        foreach ($references as $reference) {
            $pluckedReferences[$reference->user_id] = $reference->user->name();
        }
        return $pluckedReferences;
    }
}
