<?php namespace Visiosoft\ReferencesModule\Http\Controller\Admin;

use Illuminate\Support\Facades\DB;
use Visiosoft\ReferencesModule\ReferenceCode\Contract\ReferenceCodeRepositoryInterface;
use Visiosoft\ReferencesModule\ReferenceCode\Form\ReferenceCodeFormBuilder;
use Visiosoft\ReferencesModule\ReferenceCode\ReferenceCodeModel;
use Visiosoft\ReferencesModule\ReferenceCode\Table\ReferenceCodeTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ReferenceCodesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ReferenceCodeTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ReferenceCodeTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ReferenceCodeFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ReferenceCodeFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ReferenceCodeFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ReferenceCodeFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function create_user_codes(): \Illuminate\Http\RedirectResponse
    {
        $usersWithoutCode = DB::table('users_users')
            ->select('id')
            ->whereNotIn('id', ReferenceCodeModel::select(['id']))
            ->get();

        foreach ($usersWithoutCode as $userWithoutCode) {
            app(ReferenceCodeRepositoryInterface::class)->createCode($userWithoutCode->id);
        }
        return redirect()->back()->with(['success' => ['message' => trans('module::message.codes_created')]]);

    }
}
