<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleReferencesCreatePaymentsStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'payments',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'payment_type' => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options" => [
                    'individual' => 'visiosoft.module.references::field.individual',
                    'commercial' => 'visiosoft.module.references::field.commercial',
                ],
                "mode" => "radio",
            ]
        ],
        'name' => 'anomaly.field_type.text',
        'id_number' => 'anomaly.field_type.text',
        'address' => 'anomaly.field_type.text',
        'contact' => 'anomaly.field_type.text',
        'iban_no' => 'anomaly.field_type.text',
        'bank_name' => 'anomaly.field_type.text',
        'tax_administration' => 'anomaly.field_type.text',
        'tax_no' => 'anomaly.field_type.text',
        "status" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options" => [
                    'pending' => 'visiosoft.module.references::field.pending',
                    'approved' => 'visiosoft.module.references::field.approved',
                    'refused' => 'visiosoft.module.references::field.refused',
                ],
                "default_value" => 'pending',
            ]
        ],
        "amount" => 'anomaly.field_type.decimal',
    ];

    protected $assignments = [
        'payment_type' => [
            "required" => true,
        ],
        'name' => [
            "required" => true,
        ],
        'id_number',
        'address' => [
            "required" => true,
        ],
        'contact' => [
            "required" => true,
        ],
        'iban_no' => [
            "required" => true,
        ],
        'bank_name' => [
            "required" => true,
        ],
        'tax_administration',
        'tax_no',
        'status' => [
            'required' => true,
        ],
        'amount' => [
            'required' => true,
        ],
    ];
}
