<?php namespace Visiosoft\ReferencesModule\Http\Controller;
/**
 * Created by PhpStorm.
 * User: emek
 * Date: 14.11.2018
 * Time: 16:09
 */
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\References\ReferencesReferencesEntryModel;

class ReferencesController extends PublicController {

    public function index() {
        $user_id = auth()->user()->id;
        $dir = url('/') . "/register?ref=" . $user_id;

        $referencedUsers = ReferencesReferencesEntryModel::query()
            ->where('related_user_id', $user_id)
            ->leftJoin('users_users as u1', 'references_references.user_id', '=', 'u1.id')
            ->select('u1.username as name', 'references_references.*')
            ->get();

        return $this->view->make('visiosoft.module.references::reference', compact( 'referencedUsers'));
    }
}
