function copyToClipboard(element) {
    let $temp = $("<input>");
    $("body").append($temp);
    $temp.val($(element).text()).select();
    document.execCommand("copy");
    $temp.remove();
    setTooltip(copied);
    hideTooltip();
}

const copyButton = $('.copy-reference-link');
copyButton.tooltip({
    trigger: 'click',
    placement: 'top'
});

function setTooltip(message) {
    copyButton.tooltip('hide')
        .attr('data-original-title', message)
        .tooltip('show');
}

function hideTooltip() {
    setTimeout(function() {
        copyButton.tooltip('hide');
    }, 2000);
}

$('#createReferencedUser form').submit(function (e) {
    e.preventDefault()

    const form = $(this)
    const formData = form.serialize()

    $('.alert, .submit-btn-text', form).removeClass('alert-danger alert-success').hide()
    $('button', form).prop('disabled', true)
        .children('.spinner-border').css({display: 'inline-block'})

    $.ajax({
        url: registerRoute,
        data: formData,
        type: 'POST',
        success: function(data){
            if (data.success) {
                $('.alert', form)
                    .html(`
                        ${yourRefLinkTrans}:
                        <a href="${data.link}" class="alert-link ml-1">${data.link}</a>
                    `)
                    .addClass('alert-success').show()
            } else {
                $('.alert', form).text(data.error).addClass('alert-danger').show()
            }

            $('button', form).prop('disabled', false)
                .children('.spinner-border').hide()
            $('.submit-btn-text', form).show()
        }
    });
})
