<?php namespace Visiosoft\ReferencesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\Http\Controller\RegisterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\ReferencesModule\Reference\Contract\ReferenceRepositoryInterface;

class ReferencesController extends PublicController
{
    private $registerController;
    private $referenceRepository;

    public function __construct(
        RegisterController $registerController,
        ReferenceRepositoryInterface $referenceRepository
    )
    {
        parent::__construct();

        $this->registerController = $registerController;
        $this->referenceRepository = $referenceRepository;
    }

    public function index() {
        $referencedToUsers = $this->referenceRepository->findAllBy('referenced_user_id', auth()->id());
        return $this->view->make('visiosoft.module.references::references', ['referencedToUsers' => $referencedToUsers]);
    }

    public function referenceUser($userId, Request $request) {
        if (!$request->hasCookie('reference_id')) {
            Cookie::queue(Cookie::make('reference_id', $userId, 84000));
        } else {
            if (Cookie::get('reference_id') !== $userId) {
                Cookie::queue(Cookie::make('reference_id', $userId, 84000));
            }
        }

        return redirect(route('anomaly.module.users::register'));
    }
}
