<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleRecommendedadsCreateRecommendStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'recommend',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'category' => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\CatsModule\Category\CategoryModel::class,
                "mode" => "lookup",
            ]
        ],
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'category' => [
            'required' => true,
        ],
    ];

}
