<?php namespace Visiosoft\RecommendedadsModule\Listeners;

use Visiosoft\AdvsModule\Adv\Event\ViewAd;
use Visiosoft\RecommendedadsModule\Recommend\Contract\RecommendRepositoryInterface;

class AddRecommended
{
    protected $recommendRepository;

    public function __construct(RecommendRepositoryInterface $recommendRepository)
    {
        $this->recommendRepository = $recommendRepository;
    }

    public function handle(ViewAd $event)
    {
        if ($categoryID = $event->request->lastCategory()->id ?? null) {
            if ($recommend = $this->recommendRepository->findByCategoryAndUser($categoryID)) {
                $recommend->update();
            } else {
                $this->recommendRepository->create([
                    'category_id' => $categoryID
                ]);
            }
        }
    }
}
