<?php namespace Visiosoft\RecommendedadsModule\Http\Controller\Admin;

use Illuminate\Http\Request;
use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommended\Form\RecommendedFormBuilder;
use Visiosoft\RecommendedadsModule\Recommended\Table\RecommendedTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class RecommendedController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param RecommendedTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(RecommendedTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param RecommendedFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(RecommendedFormBuilder $form, RecommendedRepositoryInterface $repository, $id)
    {
        $form->setFields(['recommended']);
        $form->addField('ad_id', [
            'label' => '',
            'class' => 'hidden',
            'config' => [
                'default_value' => $id,
            ]
        ]);
        $form->setActions(['save']);
        if ($repository->isRecommended($id))
            return $form->render();
        else
            return redirect('/admin/recommendedads/edit/' . $repository->findRecommended($id)->id);
    }

    /**
     * Edit an existing entry.
     *
     * @param RecommendedFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(RecommendedFormBuilder $form, $id)
    {
        $form->setFields(['recommended', 'ad_id' => [
            'label' => '',
            'class' => 'hidden',
            'config' => [
                'default_value' => $id,
            ]
        ]]);
        return $form->render($id);
    }
}
