<?php namespace Visiosoft\RecommendedadsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedRepository;
use Anomaly\Streams\Platform\Model\Recommendedads\RecommendedadsRecommendedEntryModel;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedModel;
use Illuminate\Routing\Router;

class RecommendedadsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        RecommendedadsModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/recommendedads'           => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@index',
        'admin/recommendedads/create/{id}'    => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@create',
        'admin/recommendedads/edit/{id}' => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\RecommendedadsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\RecommendedadsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\RecommendedadsModule\Event\ExampleEvent::class => [
        //    Visiosoft\RecommendedadsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\RecommendedadsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RecommendedadsRecommendedEntryModel::class => RecommendedModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        RecommendedRepositoryInterface::class => RecommendedRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
