<?php namespace Visiosoft\RecommendedadsModule\Recommended;

use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class RecommendedRepository extends EntryRepository implements RecommendedRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var RecommendedModel
     */
    protected $model;

    /**
     * Create a new RecommendedRepository instance.
     *
     * @param RecommendedModel $model
     */
    public function __construct(RecommendedModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $ad_id
     * @return bool|mixed
     */
    public function isRecommended($ad_id)
    {
        return is_null($this->findRecommended($ad_id));
    }

    /**
     * @param $ad_id
     * @return mixed
     */
    public function findRecommended($ad_id)
    {
        return $this->model->findByAdId($ad_id);
    }

    /**
     * @param $ad_id
     * @return mixed
     */
    public function getRecommended($ad_id)
    {
        return $this->model->getByAdId($ad_id);
    }
}
