<?php namespace Visiosoft\RecommendedadsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Visiosoft\RecommendedadsModule\Listeners\AddRecommendedButton;
use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedRepository;
use Anomaly\Streams\Platform\Model\Recommendedads\RecommendedadsRecommendedEntryModel;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedModel;

class RecommendedadsModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        RecommendedadsModulePlugin::class
    ];

    protected $routes = [
        'admin/recommendedads'           => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@index',
        'admin/recommendedads/create/{id}'    => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@create',
        'admin/recommendedads/edit/{id}' => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@edit',
    ];

    protected $listeners = [
        TableIsQuerying::class => [
            AddRecommendedButton::class
        ]
    ];

    protected $bindings = [
        RecommendedadsRecommendedEntryModel::class => RecommendedModel::class,
    ];

    protected $singletons = [
        RecommendedRepositoryInterface::class => RecommendedRepository::class,
    ];
}
