<?php namespace Visiosoft\RecommendedadsModule\Recommended\Command;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;

class GetRecommended
{

    /**
     * @var $id
     */
    protected $id;

    /**
     * GetProduct constructor.
     * @param $id
     */
    public function __construct($id)
    {
        $this->id = $id;
    }


    public function handle(RecommendedRepositoryInterface $groups, AdvModel $advModel)
    {
        if ($this->id) {
            $recommended = $groups->findRecommended($this->id);
            if (!is_null($recommended)) {
                foreach ($recommended->recommended as $index => $ad) {
                    $recommended->recommended[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
                    $recommended->recommended[$index] = $advModel->AddAdsDefaultCoverImage($ad);
                }
                return $recommended->recommended;
            } else {
                $recommended = $advModel->getRecommended($this->id);
                foreach ($recommended as $index => $ad) {
                    $recommended[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
                    $recommended[$index] = $advModel->AddAdsDefaultCoverImage($ad);
                }
                return $recommended;
            }

        }
        return null;
    }
}
