<?php namespace Visiosoft\RecommendedadsModule\Listeners;

use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Contracts\Container\Container;
use Visiosoft\AdvsModule\Adv\Table\AdvTableBuilder;

class AddRecommendedButton
{
    protected $userRepository;
    private $container;

    public function __construct(UserRepositoryInterface $userRepository, Container $container)
    {
        $this->userRepository = $userRepository;
        $this->container = $container;
    }

    public function handle(TableIsQuerying $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == AdvTableBuilder::class) {
            $this->AddRecommendedButton($builder);
        }
    }

    protected function AddRecommendedButton(AdvTableBuilder $builder)
    {
        $buttons = $builder->getButtons();

        if (is_string($buttons)) {
            $buttons = $this->container->call($buttons);
        }

        if (isset($buttons['settings'])) {
            $dropdown = array_merge($buttons['settings']['dropdown'], [
                "add_recommended" => [
                    "text" => trans('visiosoft.module.recommendedads::field.add_recommended'),
                    "href" => "/admin/recommendedads/create/{entry.id}"
                ]
            ]);
            $buttons['settings']['dropdown'] = $dropdown;
            $builder->setButtons($buttons);
        }
    }
}