<?php namespace Visiosoft\RecommendedadsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommended\Command\GetRecommended;
use Visiosoft\RecommendedadsModule\Recommended\Command\GetUserRecommended;

class RecommendedadsModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getRecommendedAds',
                function ($id) {

                    if (!$ad = $this->dispatch(new GetRecommended($id))) {
                        return null;
                    }

                    return $ad;
                }
            ),
            new \Twig_SimpleFunction(
                'getUserRecommended',
                function ($userID = null) {
                    return $this->dispatch(new GetUserRecommended($userID));
                }
            ),
            new \Twig_SimpleFunction(
                'getRecommendedAdsByCfValue',
                function ($cfValue) {
                    $ads = null;
                    if ($cfValue){
                        $similarAdsCustomField = app(CustomFieldRepositoryInterface::class)->find(setting_value('visiosoft.module.recommendedads::similarAdsCustomField'))->slug ;
                        $ads=app(CustomFieldRepositoryInterface::class)->QueryAdsWithCFValue($similarAdsCustomField,$cfValue)->get();
                    }
                    return $ads;
                }
            ),
        ];
    }
}
