<?php namespace Visiosoft\RecommendedadsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AdvsModule\Adv\Event\ViewAd;
use Visiosoft\RecommendedadsModule\Listeners\AddRecommended;
use Visiosoft\RecommendedadsModule\Recommend\Contract\RecommendRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommend\RecommendRepository;
use Anomaly\Streams\Platform\Model\Recommendedads\RecommendedadsRecommendEntryModel;
use Visiosoft\RecommendedadsModule\Recommend\RecommendModel;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Visiosoft\RecommendedadsModule\Listeners\AddRecommendedButton;
use Visiosoft\RecommendedadsModule\Recommended\Contract\RecommendedRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedRepository;
use Anomaly\Streams\Platform\Model\Recommendedads\RecommendedadsRecommendedEntryModel;
use Visiosoft\RecommendedadsModule\Recommended\RecommendedModel;

class RecommendedadsModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        RecommendedadsModulePlugin::class
    ];

    protected $routes = [
        'admin/recommendedads/recommend'           => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendController@index',
        'admin/recommendedads/recommend/create'    => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendController@create',
        'admin/recommendedads/recommend/edit/{id}' => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendController@edit',
        'admin/recommendedads'           => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@index',
        'admin/recommendedads/create/{id}'    => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@create',
        'admin/recommendedads/edit/{id}' => 'Visiosoft\RecommendedadsModule\Http\Controller\Admin\RecommendedController@edit',
    ];

    protected $listeners = [
        TableIsQuerying::class => [
            AddRecommendedButton::class
        ],
        ViewAd::class => [
            AddRecommended::class
        ]
    ];

    protected $bindings = [
        RecommendedadsRecommendEntryModel::class => RecommendModel::class,
        RecommendedadsRecommendedEntryModel::class => RecommendedModel::class,
    ];

    protected $singletons = [
        RecommendRepositoryInterface::class => RecommendRepository::class,
        RecommendedRepositoryInterface::class => RecommendedRepository::class,
    ];
}
